<?php
/*--------------------------------------------------------------------
 AttributeWeightDtoCollection.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\DTO;

use Countable, Iterator, ArrayAccess, JsonSerializable, InvalidArgumentException;

/**
 * Class AttributeWeightDtoCollection
 * @package Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\DTO
 */
class AttributeWeightDtoCollection implements Countable, Iterator, ArrayAccess, JsonSerializable
{
    /**
     * @var AttributeWeightDto[]
     */
    protected $values = [];
    
    /**
     * @var int
     */
    protected $position = 0;
    
    /**
     * SellingUnitImagesCollection constructor.
     *
     * @param AttributeWeightDto[] $weightDtos
     */
    public function __construct(array $weightDtos = [])
    {
        if (count($weightDtos)) {
            
            foreach ($weightDtos as $image) {
                
                $this[] = $image;
            }
        }
    }
    
    
    /**
     * @inheritDoc
     */
    public function current(): AttributeWeightDto
    {
        return $this->values[$this->position];
    }
    
    
    /**
     * @inheritDoc
     */
    public function next(): void
    {
        $this->position++;
    }
    
    
    /**
     * @inheritDoc
     */
    public function key(): int
    {
        return $this->position;
    }
    
    
    /**
     * @inheritDoc
     */
    public function valid(): bool
    {
        return isset($this->values[$this->position]);
    }
    
    
    /**
     * @inheritDoc
     */
    public function rewind(): void
    {
        $this->position = 0;
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetExists($offset): bool
    {
        return isset($this->values[$offset]);
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetGet($offset)
    {
        return $this->values[$offset];
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetSet($offset, $value): void
    {
        if (!$value instanceof AttributeWeightDto) {
            
            throw new InvalidArgumentException(static::class . ' only accepts ' . AttributeWeightDto::class);
        }
        
        if (empty($offset)) {
            $this->values[] = $value;
        } else {
            $this->values[$offset] = $value;
        }
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetUnset($offset): void
    {
        unset($this->values[$offset]);
    }
    
    
    /**
     * @inheritDoc
     */
    public function count(): int
    {
        return count($this->values);
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize()
    {
        return $this->values;
    }
}